<?php
namespace WPO\WC\PDF_Invoices_Pro;

use WPO\WC\PDF_Invoices\Compatibility\WC_Core as WCX;
use WPO\WC\PDF_Invoices\Compatibility\Order as WCX_Order;
use WPO\WC\PDF_Invoices\Compatibility\Product as WCX_Product;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( !class_exists( '\\WPO\\WC\\PDF_Invoices_Pro\\Emails' ) ) :

class Emails {
	public function __construct() {
		add_filter( 'woocommerce_email_classes', array( $this, 'add_emails' ) );
		$this->email_actions = array (
			'woocommerce_order_status_processing',
			'woocommerce_payment_complete',
		);
		// register status actions to make sure triggers are pulled!
		$this->register_email_actions();
	}

	/**
	 * Register email actions (backwards compatible with WC 2.2 & 2.1)
	 *
	 * @access public
	 * @return void
	 */
	public function register_email_actions () {
		if ( version_compare( WOOCOMMERCE_VERSION, '2.3', '>=' ) ) {
			// use filter when possible
			add_filter( 'woocommerce_email_actions', array( $this, 'woocommerce_email_actions' ), 10, 1 );
		} else {
			// backwards compatible method
			global $woocommerce;
			foreach ( $this->email_actions as $action ) {
				add_action( $action, array( $woocommerce, 'send_transactional_email' ), 10, 10 );
			}

		}
	}

	/**
	 * Add email actions.
	 *
	 * @access public
	 * @return $email_actions
	 */
	public function woocommerce_email_actions ( $email_actions ) {
		return array_merge($email_actions, $this->email_actions);
	}

	public function add_emails ( $email_classes ) {
		// add our custom email classes to the list of email classes that WooCommerce loads
		if ( version_compare( WOOCOMMERCE_VERSION, '2.2', '>=' ) ) {
			$email_classes['WC_Email_Customer_Credit_Note'] = include( 'email-customer-credit-note.php' );
		}
		$email_classes['WC_Email_PDF_Order_Notification'] = include( 'email-pdf-order-notification.php' );
		return $email_classes;
	}


} // end class

endif; // end class_exists

return new Emails();